#! /bin/sh

echo "Extracting ircd/version.c ..."

srcdir=$1

if test -r version.c
then
   generation=`sed -n 's/^const char \*generation = \"\(.*\)\";/\1/p' < version.c`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

creation=`date | \
awk '{if (NF == 6) \
	 { print $1 " " $2 " " $3 " " $6 " at " $4 " " $5 } \
else \
	 { print $1 " " $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

/bin/cat >version.c <<!SUB!THIS!
/*
 * IRC - Internet Relay Chat, ircd/version.c
 * Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "version.h"
#include "patchlevel.h"
#include "patchlist.h"

const char *generation = "$generation";
const char *creation = "$creation";
const char *version = BASE_VERSION RELEASE PATCHLEVEL PATCHLIST;

const char *infotext[] = {
    "IRC --",
    "This program is free software; see LICENSE in the distribution",
    "",
    "Based on the original code written by Jarkko Oikarinen, version 2.6:",
    "Wiz          Jarkko Oikarinen         <jto@tolsun.oulu.fi>",
    "",
    "The main developer of version u2.9 and u2.10 was:",
    "Run          Carlo Wood               <carlo@runaway.xs4all.nl>",
    "",
    "The head developer of the u2.10 source tree was:",
    "Bleep        Thomas Helvey            <tomh@inxpress.net>",
    "",
    "The current maintainors of the u2.10 source tree are:",
    "Isomer       Perry Lorier             <perry@coders.net>",
    "Kev          Kevin Mitchell           <klmitch@mit.edu>",
    "",
    "Contributors to this release:",
    "Kev, Isomer, Gte, Ghostwolf, Bleep",
    "Debugging and support:",
    "SeKs, Maniac-, HeKTik, OmniDynmc, Liandrin, Dianora",
    "Special thanks to Angel and Buff for believing in us and putting"
    "up with frantic late night phone calls"
    "",
    "Thanks goes to all other people who contributed to any version.",
    "A full listing of all coders can be found in doc/Authors in the",
    "source.",
    "",
    "Sources:",
!SUB!THIS!

for file in ${srcdir}/ircd/*.c ; do
 echo "    \"[" `./umkpasswd -5 $file` " ]\"," >> version.c
done;

echo "    \"\"," >> version.c
echo "    \"Headers:\"," >> version.c

for file in ${srcdir}/include/*.h ; do
 echo "    \"[" `./umkpasswd -5 $file` " ]\"," >> version.c
done;

/bin/cat >>version.c <<!SUB!THIS!
    0,
};
!SUB!THIS!
