/*
** Copyright (C) 2003 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
** MA 02111-1307, USA
**
** @(#)$Id: _smat_resize.c,v 1.1 2003/03/07 02:36:10 klmitch Exp $
*/
#include "dbprim.h"
#include "dbprim_int.h"

RCSTAG("@(#)$Id: _smat_resize.c,v 1.1 2003/03/07 02:36:10 klmitch Exp $");

unsigned long
_smat_resize(hash_table_t *table, unsigned long new_mod)
{
  smat_table_t *stab;

  stab = ht_extra(table);

  /* If a resize callback was registered, call it */
  if (stab->st_resize)
    return (*stab->st_resize)(stab, new_mod);

  return 0; /* allow the resize */
}
